;*
;* JAVA VIRTUAL MACHINE FOR APPLE II PRODOS
;*
	.INCLUDE	"global.inc"
	.INCLUDE	"class.inc"
	.IMPORT	UTIL_INIT,HOME,GETLN,PRSTR,COUT,CROUT,PUTS,PRBYTE,KBWAIT,MEMCPY
	.IMPORT	HMEM_INIT,HMEM_ALLOC,HMEM_FREE
	.IMPORT	HMEM_PTR,HMEM_REF_INC,HMEM_REF_DEC,HMEM_LOCK,HMEM_GC
	.IMPORT	HSTR_INIT,STR_HASH,HSTR_HASH,HSTRPL_ADD,HSTRPL_DEL
	.IMPORT	LOADCLASS_INIT,IO_INIT,IODEV_INIT
	.IMPORT	HCLASS_INIT,HCLASS_NAME,HCLASS_HNDL,CLASS_MATCH_NAME,CLASS_MATCH_DESC
	.IMPORT	RESOLVE_CLASS,RESOLVE_METHOD,CLASS_METHODPTR
	.IMPORT	SYSCLASS_INIT,EXCEPT_INIT,SYS_CALL
	.IMPORT	HMAINNAMESTR,HMAINDESCSTR
	.IMPORT	THREAD_INIT,THREAD_NEW,THREAD_SETRUN,THREAD_YIELD
	.IMPORT	ITHREAD_PUSH_SP,ITHREAD_PUSH_TLS,LOADEXECSTATE,BEST_THREAD
	.IMPORT	INTERP_INIT,INTERP_END
	.IMPORT	CLASSPREFIX,PREFIX_SET,FILE_OPEN,FILE_CLOSE,FILE_SETBUFFER,FILE_BLOAD
	.EXPORT	INIT_START,VM_RESTART,WARM_INIT

.IFDEF	DEBUG
	.IMPORT	HMEM_DUMP,HSTRPL_DUMP,KBWAIT
.ENDIF

PARSELEN	EQU	$A0
	.SEGMENT "INIT"
INIT_START:
VM_WARMINIT:	SEI			; DISABLE INTERRUPTS
	LDX	#$92
:	STX	TMP
	LDA	#IOCTL_DISABLE
	JSR	SYS_CALL		; DISABLE DEVICES
	LDX	TMP
	INX
	INX
	CPX	#$A0
	BNE	:-
	JSR	PRODOS
	.BYTE	$41		; DE-ALLOC INTERRUPT
	.ADDR	DEALLOCINTPARMS
	LDA	#26		; DEACTIVATE 80 COL CARDS
	JSR	COUT
	LDA	#'1'|$80
	JSR	COUT
	LDA	#8		; PRINT BACKSPACE IN CASE 1 SHOWED UP
	JSR	COUT
	LDA	#' '|$80
	JSR	COUT
	LDA	#21
	JSR	COUT
	BIT	$C054		; SET TEXT MODE
	BIT	$C051
	JSR	CROUT
	PSTR	"Press ESC to reboot, RETURN to continue."
	JSR	KBWAIT
	CMP	#$9B
	BNE	:+
	BIT	ROMIN		; SWAP ROM IN
	LDA	#$00
	STA	$3F4		; INVALIDATE POWER-UP BYTE
	JMP	($FFFC)		; RESET
:	JSR	CROUT
	LDA	#$AA
	STA	WARM_INIT
	LDX	#$FF		; RESET STACK
	TXS
	LDA	#$00		; NO PASSED IN PARAMS
	PHA
VM_INIT:	LDX	#$F0		; CLEAR LINK TABLE
	LDA	#$00
:	DEX
	STA	LINK_TABLE,X
	BNE	:-
;
; PRINT BANNER MESSAGE
;
	JSR	IO_INIT
	JSR	HOME		; SKIP BANNER ON WARM INIT
	PSTRLN	"VM02 Version 0.80, Beta Release 1"
	PSTRLN	"Copyright 2008, David Schmenk"
.IFDEF	DEBUG
	PSTRLN	"DEBUG ENABLED"
.ENDIF
.IFDEF	DEBUG_DUMP
	LDA	#$00		; TURN ON PRINTER
	STA	CSWL
	LDA	#$C1
	STA	CSWH
.ENDIF
	JSR	UTIL_INIT
	JSR	HMEM_INIT
	JSR	HSTR_INIT
	JSR	HCLASS_INIT
	JSR	INTERP_INIT
	JSR	LOADCLASS_INIT
	JSR	SYSCLASS_INIT
	JSR	THREAD_INIT
	JSR	EXCEPT_INIT
	JSR	IODEV_INIT
	LDA	#<VM_RESTART
	STA	LINK_EXIT
	LDA	#>VM_RESTART
	STA	LINK_EXIT+1
	SEI			; DISABLE INTERRUPTS
;
; LOOK FOR STARTUP FILE IN INPUT BUFFER ($01FF = LEN OF STARTUP STRING)
;
	PLA
	BEQ	:+
	TAX
	BNE	PARSECMD
:	LDA	#<STARTUP		; CHECK FOR EXISTANCE OF STARTUP FILE
	LDX	#>STARTUP
	JSR	FILE_OPEN
	BCS	CMDLINE		; NOPE, INPUT COMMAND LINE
	JSR	FILE_CLOSE
	LDA	#$00
	PHA
	STA	PARSELEN
	LDA	#<STARTUP
	LDX	#>STARTUP
	JMP	SETRUNCLASS
;
; PROMPT FOR MAIN CLASS
;
CMDLINE:	PSTR	"Main class"
	LDA	#':'|$80
	STA	PROMPTCHAR
	JSR	GETLN
PARSECMD:	CPX	#$00
	BEQ	CMDLINE
	STX	PARSELEN
	LDX	#$00
	JSR	PARSELINE	
	TXA			; CLEVERLY PUT STRING LENGTH
	PHA			; IN FRONT OF INPUT BUFFER AT $200
	LDA	#$FF
	LDX	#$01
SETRUNCLASS:	JSR	HSTRPL_ADD
	STA	RUNCLASS
	STX	RUNCLASS+1
PARSEARGS:	PLA
	BEQ	:+
	TAX
	JSR	PARSELINE
	TXA
	BEQ	:+
	PHA
	LDA	#$FF
	LDX	#$01
	JSR	HSTRPL_ADD
	STY	TMP
	LDY	NARGS
	STA	HARGSL,Y
	TXA
	STA	HARGSH,Y
	LDA	TMP
	STA	ARGSHASH,Y
	INC	NARGS
	BNE	PARSEARGS
:	LDA	NARGS		; ALLOCATE ARGS ARRAY
	ASL
	ASL
	CLC
	ADC	#$02
	LDX	#$00
	LDY	#$01
	JSR	HMEM_ALLOC
	STA	HARGS
	STX	HARGS+1
	JSR	HMEM_PTR
	STA	$A0
	STX	$A1
	LDY	#$00
	LDA	NARGS
	STA	($A0),Y
	TYA
	TAX
	INY
	STA	($A0),Y
	LDA	NARGS
	BEQ	:+
	INY
FILLARGS:	LDA	HARGSL,X
	STA	($A0),Y
	INY
	LDA	HARGSH,X
	STA	($A0),Y
	INY
	LDA	#CL_STR
	STA	($A0),Y
	INY
	LDA	ARGSHASH,X
	STA	($A0),Y
	INY
	INX
	DEC	NARGS
	BNE	FILLARGS
RUNMAIN:	LDA	#$00		; NEED TO CREATE THREAD INSTANCE OBJECT
:	TAX
	JSR	THREAD_NEW
	LDA	#T_REF
	LDX	#CL_ARRAY
	JSR	ITHREAD_PUSH_SP		; PUSH MAIN PARAM ON STACK
	LDA	HARGS+1
	LDX	HARGS
	JSR	ITHREAD_PUSH_SP
	LDA	HMAINNAMESTR		; RUN MAIN METHOD
	LDX	HMAINNAMESTR+1
	JSR	ITHREAD_PUSH_SP
	LDA	HMAINDESCSTR
	LDX	HMAINDESCSTR+1
	JSR	ITHREAD_PUSH_SP
	LDA	RUNCLASS		; RETRIEVE CLASS NAME
	LDX	RUNCLASS+1
	JSR	ITHREAD_PUSH_SP
	JSR	THREAD_SETRUN
	STY	BEST_THREAD
	LDA	#$00		; CLEAR INPUT BUFFER
	STA	$0200
	BIT	CLRKBD
	JSR	LOADEXECSTATE		; JUMP TO SCHEDULER
	PERR	"OOPS, RETURN FROM YIELD"
	BRK
	LDA	INTERP_END		; DUMMY READ TO MAKE EXTERN SHOW UP IN MAP FILE
PARSELINE:	LDY	#$00		; SKIP PREVIOUS STRING
	LDA	INQUOTE
	BEQ	:+
	DEC	INQUOTE
	INX
:	LDA	PARSELEN
	STX	PARSELEN
	SEC
	SBC	PARSELEN
	STA	PARSELEN
	BNE	SKIPPREV
PARSEDONE:	LDX	#$00
	RTS
SKIPPREV:	LDA	$0200,X
	STA	$0200,Y
	INY
	INX
	BNE	SKIPPREV
SKIPSPACE:	LDA	$0200
	CMP	#'"'|$80
	BEQ	PARSEQUOTE
	CMP	#$A1		; CHECK FOR WHITESPACE
	BCS	PARSESTR
	DEC	PARSELEN
	BEQ	PARSEEXIT
:	LDA	$0201,X		; SHIFT BUFFER DOWN
	STA	$0200,X
	INX
	BNE	:-
	BEQ	SKIPSPACE
PARSESTR:	INX
	CPX	PARSELEN
	BEQ	PARSEEXIT
	LDA	$0200,X
	CMP	#$A1
	BCS	PARSESTR
PARSEEXIT:	RTS
PARSEQUOTE:	DEC	PARSELEN
:	LDA	$0201,X		; SKIP QUOTE CHAR
	STA	$0200,X
	INX
	BNE	:-
	BEQ	:+
FINDQUOTE:	INX
:	CPX	PARSELEN
	BEQ	PARSEEXIT
	LDA	$0200,X
	CMP	#'"'|$80
	BNE	FINDQUOTE
	INC	INQUOTE
	RTS
STARTUP:	.BYTE	7,"STARTUP"
RUNCLASS:	.WORD	$0000
NARGS:	.BYTE	$00
INQUOTE:	.BYTE	$00
HARGSL:	.RES	10
HARGSH:	.RES	10
ARGSHASH:	.RES	10
HARGS:	.WORD	$0000
WARM_INIT:	.BYTE	$00
VM02SMALL:	.BYTE	4,"VM02"
DEALLOCINTPARMS: .BYTE	$01
	.BYTE	$00		; INT NUM

	.CODE
;*
;* MAIN ENTRYPOINT
;*
;	ORG	$1000
VM_STARTUP:	JMP	VM_INIT
;*
;* ALL THREADS ARE DONE, OR AN UNRECOVERABLE ERROR OCCURED
;* EXIT TO PRODOS
;*
VM_RESTART:	PHA
	TXA
	PHA
	LDA	#<CLASSPREFIX		; RELOAD VM02 FROM ORIGINAL LOCATION
	LDX	#>CLASSPREFIX
	JSR	PREFIX_SET
	LDA	#$00
	LDX	#$10
	JSR	FILE_SETBUFFER
	LDA	#<VM02SMALL
	LDX	#>VM02SMALL
	JSR	FILE_BLOAD
	PLA
	STA	EXIT_STATUS+1		; SAVE EXIT STATUS
	PLA
	STA	EXIT_STATUS
	JMP	VM_WARMINIT		; WARM INIT
EXIT_STATUS:	.BYTE	$00,$00